import numpy as np
from scipy import signal
import matplotlib.pyplot as plt
import csv

#csv.field_size_limit(sys.maxsize)

# normalized standard deviation
apodization = 0.2
# the interferometric signal, the one that has to be fourier transformed
input_signal = np.array
# the position array correspondent to the interferogram
position = np.array
start_wavelength = 150
end_wavelength = 1500
# number of sample points
samples = 200

with open('Initialize_parameters_int.txt', 'r') as csvFile:
    reader = csv.reader(csvFile, delimiter='\t')
    position=np.array(next(reader)).astype(np.float)
    input_signal=np.array(next(reader)).astype(np.float)
csvFile.close()
len=len(input_signal)
# sample spacing
T = 1.0 / 800.0
x = np.linspace(start_wavelength, end_wavelength, len)
x1 = np.linspace(start_wavelength, end_wavelength, 100)

#y = np.sin(50.0 * 2.0*np.pi*x) + 0.5*np.sin(80.0 * 2.0*np.pi*x)
y = np.sin(x)
w = signal.gaussian(len, std=150)
w1=np.hamming(len)

yf = np.fft.fft(input_signal*w)

xf = np.linspace(0.0, 1.0 / (2.0*T), len)
#xf=np.array(x)
#ywf = np.fft.fft(np.convolve(i,w))
ywf = np.fft.fft(input_signal*w1)

#plt.plot(position[:100], input_signal[:100])


plt.plot(position, 1.0 / len * np.abs(yf[0:len]))
plt.plot(x, 1.0 / len * np.abs(ywf[0:len]))

#plt.semilogy(xf[1:len // 2], 2.0 / len * np.abs(yf[1:len // 2]), '-b')
#plt.semilogy(xf[1:len // 2], 2.0 / len * np.abs(ywf[1:len // 2]), '-r')

#plt.plot(x, w)
#plt.plot(x1,w1)
plt.legend(['FFT', 'FFT w. window'])
plt.grid()
plt.show()
